% --- Source file: emgmm.m_step ---
\name{emgmm.m_step}
\alias{emgmm.m_step}
\title{M-STEP GMM}
\description{
  M-Step of the Expectation-Maximization algorithm (Gaussian Mixture Models)
}
\usage{
emgmm.m_step(x, Alpha)
}
\arguments{
  \item{x}{
    Data matrix. Each row corresponding to an observation,
    and each column corresponding to a variable. 
    \code{dim=[Ndata,Ndim]}
  }
  \item{Alpha}{
    Expected classes for each sample, computed by \code{\link{emgmm.e_step}}.
    \code{dim=[Ncomp,Ndata]}
  }
}
\value{
    \item{M}{GMM mean vectors: \code{dim=[Ncomp,Ndim]}.}
    \item{C}{GMM covariance matrix: \code{dim=[Ndim,Ndim,Ncomp]}.}
    \item{W}{GMM weight values: \code{dim=[Ncomp,1]}.}
}
\details{
  This procedure is performed for microarray data. Then, only 1D and 2D
  data samples are allowed. Case examples:
  \item{1D}{CNV models, working with one channel intensity values}
  \item{2D}{Genotype models, working with allelic frequency and intensity values}
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{
  \code{\link{emgmm.em}}, \code{\link{emgmm.pdfgauss}}, \code{\link{emgmm.e_step}}.
}
\eof
