\name{emgmm.pdfgauss}
\alias{emgmm.pdfgauss}
\title{GMM PDF EVALUATION}
\description{
  Evaluates a multi-variate Gaussian probability density function for given 
  input observations.
}
\usage{
emgmm.pdfgauss(x, model)
}
\arguments{
  \item{x}{ 
    Data matrix. Each row corresponding to an observation.
    \code{dim=[Ndata,Ndim]}
  }
  \item{model}{
    Gaussian Mixture Model:
    \item{M}{GMM mean vectors: \code{dim=[Ncomp,Ndim]}.}
    \item{C}{GMM covariance matrix: \code{dim=[Ndim,Ndim,Ncomp]}.}
    \item{W}{GMM weight values: \code{dim=[Ncomp,1]}.}
  }
}
\details{
  Computes the PDF data values corresponding to each component of a GMM.
  If the component weight is 0, the returned pdf value for all data is also 0.
}
\value{
  Values of probability density function. Each column corresponding to an observation
  and each row corresponding to a model component.
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{
  \code{\link{mahalanobis}}, \code{\link{emgmm.em}}, 
  \code{\link{emgmm.e_step}}, \code{\link{emgmm.m_step}}.
}