\name{genotype.compute}
\alias{genotype.compute}
\title{SNP genotyping}
\description{
    SNP genotyping by applying a Histogram/GMM-based method.
}
\usage{
    genotype.compute(data, max_dev = 1, limvar = c(1e-04, 0.04), mdlog = 0.1, max_iter = 2)
}
\arguments{
  \item{data}{ 
    data matrix, each row corresponding to a sample,
    column 1 corresponding to B-allele frequency and
    column 2 corresponding to absolute intensity.
  }
  \item{max_dev}{  
   Samples which distance to the genotype center exceeds max_dev times the standard 
   deviation of the genotype model will typed as outliers.  
  }
  \item{limvar}{
   \code{limvar=c(minimum,maximum)} Minimum and maximum variance values allowed
   for the BAF component.
  }
  \item{max_iter}{
   Maximun number of EM iterations allowed.
  }
  \item{dlog}{
   Minimum LLH gain required for a new EM iteration.
  }
}
\details{
SNP genotyping is carryed out in two steps:
  \item{HISTOGRAM}{Initial genotype models are computed using a partitioning 
   algorithm over the BAF data histogram.}
  \item{EM-GMM}{EM is applyed to the initial models.}
}
\value{
  \item{data_gen}{Vector corresponding to genotypes assigned to each sample [1xNsamples].}
  \item{index}{Index of the non-outlier samples}
  \item{model}{Final genotype models}
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{\code{\link{emgmm.em}, \link{genotype.marker}}}
\eof