\name{genotype.marker}
\alias{genotype.marker}
\title{SNP genotyping}
\description{
    Performs SNP genotyping and quality control over the resulting clusters.
}
\usage{
genotype.marker(FI, verbose = 0)
}
\arguments{
  \item{FI}{ 
    data matrix, each row corresponding to a sample,
    column 1 corresponding to B-allele frequency and
    column 2 corresponding to absolute intensity.
  }
  \item{verbose}{
    If verbose = 1, numerical results and figures are screened.
  }
}
\value{
  \item{out_gt}{Value returned by \code{\link{genotype.compute}}}
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{\code{\link{genotype.compute}}}
\examples{
f_data <- "http://www.urr.cat/cnv/data/input_regions.txt"
data   <- file(f_data, "r")
## Random marker to be processed
index  <- runif(1,1,100)
for (i in 1:index) dat <- readLines(data, 1)
## Reading line and formatting data
dat    <- strsplit(dat, "\t")[[1]]
dat    <- as.numeric(dat[4:length(dat)])
AB     <- t(rbind(dat[seq(1, length(dat), 2)], dat[seq(2, length(dat), 2)]))
input  <- which((AB[, 1] > -0.5) & (AB[, 2] > -0.5))
AB     <- AB[input, ]
## Normalization
def    <- preprocessing(AB, verbose = 0, plate = as.vector(matrix(1, 1, dim(AB)[1])))
## SNP Genotyping
def    <- try(genotype.marker(def$FI, verbose = 1), silent = FALSE)
}
\eof