\name{genotype.plot.pdf}
\alias{genotype.plot.pdf}
\title{Plots SNP genotype models}
\description{Contour plot of a GMM distribution.}
\usage{
genotype.plot.pdf(model, add = FALSE, xlim = c(-0.1, 1.1), ylim = c(0, 2.4), steps = 120, opt = 0)
}
\arguments{
  \item{model}{
    \item{M}{GMM mean vectors: \code{dim=[Ncomp, 2]}.}
    \item{C}{GMM covariance matrix: \code{dim=[2, 2, Ncomp]}.}
    \item{W}{GMM weight values: \code{dim=[Ncomp, 1]}.}
   }
  \item{add}{contour(... add=TRUE/FALSE ...) }
  \item{xlim}{x grid limits}
  \item{ylim}{y grid limits}
  \item{steps}{grid length: \code{dim=[step,step]}}
  \item{opt}{If 1, weighted model, else ignores information in model$W}
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{\code{\link{contour}},\code{\link{genotype.marker}},\code{\link{genotype.plot.result}}}
\eof
