% --- Source file: preprocessing.Rd ---
\name{preprocessing}
\alias{preprocessing}
\title{ Plate normalization and channel intensity scaling }
\description{
  This function performs a per-plate normalization algorithm and scales
  both channel intensities to correct differences between channel sensibilities. 
  B-allele frequency and absolute intensity are also computed.
}
\usage{
preprocessing(AB, plate, verbose = 0)
}
\arguments{
  \item{AB}{
    Intensity data. AB[,1] channel A intensities. AB[,2] channel B intensities.
  }
  \item{plate}{
    A vector with the plate index of each sample. Samples with plate index equal
    to 0 will be excluded.
  }
  \item{verbose}{
    If verbose = 1, normalization values will be screened.
  }
}
\value{
  \item{ok}{
    If ok = 0, data error.
  }
  \item{AB}{
    Vector containing channel A & B scaled intensities (Ndata x 2).
  }
  \item{FI}{
    A vector containing the B-allele frequencies and the absolute intensities (Ndata x 2).
  }
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{
  \code{\link{preprocessing.compute_inorm}, \link{preprocessing.compute_fi}}.
}
\eof