% --- Source file: preprocessing.compute_fi.Rd ---
\name{preprocessing.compute_fi}
\alias{preprocessing.compute_fi}
\title{Coordinate transformation to B-allele frequency and absolute intensity}
\description{
  Computes B-allele frequency and absolute normalized intensity 
  for each sample.
}
\usage{
preprocessing.compute_fi(x)
}
\arguments{
  \item{x }{
    data matrix, each column corresponding to a channel (A and B),
    and each row corresponding to a sample. 
    Dimension must be \code{[Nsamples,2]}.
  }
}
\value{
  \item{ok}{
    0 if data error}
  \item{FI}{
    data matrix, each row corresponding to a sample,
    column 1 corresponding to allelic frequency and
    column 2 corresponding to absolute intensity.
  }
  \item{i_norm}{
    vector of length = 2, defining the intensity scaling values used for channels A and B.
  }
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{
  \code{\link{preprocessing.compute_inorm}}.
}
\eof